//-----------------------------------------------------------------------------
//Copyright  2000-2003 TogetherSoft Corporation, a wholly owned subsidiary of Borland Software Corporation. All rights reserved. All patents pending.
//-----------------------------------------------------------------------------

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using CSCashSales.data_objects;

namespace CSCashSales.user_interface
{
  /// <summary>
  /// Payment form.
  /// </summary>
  /// <TgData>
  /// </TgData>
  public class PaymentForm : System.Windows.Forms.Form
  {
    /// <summary>
    ///    Required designer variable.
    /// </summary>
    private System.ComponentModel.Container components;
		private System.Windows.Forms.Button m_btnCancel;
		private System.Windows.Forms.Button m_btnOk;
		private System.Windows.Forms.TextBox m_txtAmount;
		private System.Windows.Forms.Label label1;

		/// <summary>
		/// A reference to current cash sale.
		/// </summary>
		private ICashSale m_objSale;

		/// <summary>
		/// Constructor.
		/// </summary>
		/// <param name="sale"> a reference to current cash sale </param>
        public PaymentForm( ICashSale sale )
        {
            //
            // Required for Windows Form Designer support
            //
            InitializeComponent();

			m_objSale = sale;
			//m_txtAmount.Text = Utils.AsCurrency(m_objSale.getTotal());
			m_txtAmount.Text = m_objSale.getTotal().ToString("f2");
        }

      /// <summary>
      ///    Clean up any resources being used.
      /// </summary>
      protected override void Dispose( bool disposing )
      {
        if( disposing )
        {
          if(components != null)
          {
            components.Dispose();
          }
        }
        base.Dispose( disposing );
      }

        /// <summary>
        ///    Required method for Designer support - do not modify
        ///    the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container ();
			this.m_txtAmount = new System.Windows.Forms.TextBox ();
			this.label1 = new System.Windows.Forms.Label ();
			this.m_btnOk = new System.Windows.Forms.Button ();
			this.m_btnCancel = new System.Windows.Forms.Button ();
			//@this.TrayHeight = 0;
			//@this.TrayLargeIcon = false;
			//@this.TrayAutoArrange = true;
			m_txtAmount.Location = new System.Drawing.Point (8, 40);
			m_txtAmount.TabIndex = 1;
			m_txtAmount.Size = new System.Drawing.Size (168, 20);
			m_txtAmount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			label1.Location = new System.Drawing.Point (8, 16);
			label1.Text = "Please enter the payment amount:";
			label1.Size = new System.Drawing.Size (184, 16);
			label1.TabIndex = 0;
			m_btnOk.Location = new System.Drawing.Point (192, 8);
			m_btnOk.Size = new System.Drawing.Size (75, 23);
			m_btnOk.TabIndex = 2;
			m_btnOk.Text = "Ok";
			m_btnOk.Click += new System.EventHandler (this.m_btnOk_Click);
			m_btnCancel.Location = new System.Drawing.Point (192, 40);
			m_btnCancel.Size = new System.Drawing.Size (75, 23);
			m_btnCancel.TabIndex = 3;
			m_btnCancel.Text = "Cancel";
			m_btnCancel.Click += new System.EventHandler (this.m_btnCancel_Click);
			this.Text = "Payment";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
			this.AutoScaleBaseSize = new System.Drawing.Size (5, 13);
			this.ClientSize = new System.Drawing.Size (272, 77);
			this.Controls.Add (this.m_btnCancel);
			this.Controls.Add (this.m_btnOk);
			this.Controls.Add (this.m_txtAmount);
			this.Controls.Add (this.label1);
		}

		/// <summary>
		/// An event handler of Cancel button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnCancel_Click (object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// An event handler of Ok button.
		/// </summary>
		/// <param name="sender"> the event sender </param>
		/// <param name="e"> the event detail </param>
		protected void m_btnOk_Click (object sender, System.EventArgs e)
		{
			String strAmount = m_txtAmount.Text;
			//Decimal dcmAmount = Decimal.FromString(strAmount);
			Decimal dcmAmount = Decimal.Parse(strAmount);
			if(m_objSale.isPaymentValid(dcmAmount))
			{
				m_objSale.setPayment(dcmAmount);
				this.Close();
			}
			else
				MessageBox.Show(this,"Payment amount should be greater/equal than total.");
		}
    }
}
